//=============================================================================
// CriticalDamageColor.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2022/08/5 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc クリティカルダメージ色変更
 * @target MZ
 * @author くろあめ
 *
 * @param DamFontUp
 * @text ダメージフォント拡大ポイント
 * @desc ダメージ表示のフォントアップ数です、ツクール標準では、標準フォントポイント+4がダメージのフォントサイズです
 * @default 6
 * @type number
 *
 * @param DamFontChange
 * @text 通常ダメージフォント変更フラグ
 * @desc 通常ダメージの文字色を、デフォルトから変更するかどうかのフラグです。true設定で変更処理を行います
 * @default false
 * @type boolean
 *
 * @param DamColor
 * @text ダメージ文字色
 * @desc 左からカンマ区切りで、R,G,B,不透明度(0~1)で設定してください
 * @default 250, 245, 245, 1
 * @type text
 * 
 * @param DamEdge
 * @text ダメージ文字縁取り色
 * @desc 左からカンマ区切りで、R,G,B,不透明度(0~1)で設定してください
 * @default 144, 16, 64, 1
 * @type text
 *
 * @param CrtDamFontUp
 * @text クリティカル時文字フォント拡大ポイント
 * @desc クリティカル時にダメージ表示を大きくする場合、大きくする値をフォントのポイント値で指定してください
 * @default 4
 * @type number
 *
 * @param CrtDamColor
 * @text クリティカルダメージ文字色
 * @desc 左からカンマ区切りで、R,G,B,不透明度(0~1)で設定してください
 * @default 50, 10, 5, 0.95
 * @type text
 * 
 * @param CrtDamEdge
 * @text クリティカルダメージ文字縁取り色
 * @desc 左からカンマ区切りで、R,G,B,不透明度(0~1)で設定してください
 * @default 255, 84, 48, 0.9
 * @type text
 *
 * @param CrtFlashColor
 * @text クリティカル時文字フラッシュ色
 * @desc 左からカンマ区切りで、R,G,B,不透明度(0~255)で設定してください
 * @default 255,245,240,245
 * @type text
 * 
 * @param CrtFlashTime
 * @text クリティカル時文字フラッシュ色
 * @desc フレーム単位で指定してください
 * @default 30
 * @type number
 *
 * @help
 * 通常時、およびクリティカルの発生時の
 * ダメージポップアップの色や大きさを変更します。
 *
 * このプラグインは、ダメージスプライト制御の関数を再定義する都合上
 * やや競合性の高い作りになっています
 * ほかのダメージ表示変更関連のスクリプトと共存させるときには
 * 細心の注意を払ってください。
 */

(function() {

const parameters    = PluginManager.parameters('CriticalDamageColor');
const DamFontUp     = Number(parameters['DamFontUp']);
const DamFontChange = Boolean(parameters['DamFontChange']);
const DamColor      = String(parameters['DamColor']);
const DamEdge       = String(parameters['DamEdge']);
const CrtDamFontUp  = Number(parameters['CrtDamFontUp']);
const CrtDamColor   = String(parameters['CrtDamColor']);
const CrtDamEdge    = String(parameters['CrtDamEdge']);
const CrtFlashColor = String(parameters['CrtFlashColor']);
const CrtFlashTime  = Number(parameters['CrtFlashTime']);


const _Sprite_Damage_initialize_criDamCl = Sprite_Damage.prototype.initialize;
Sprite_Damage.prototype.initialize = function() {
    _Sprite_Damage_initialize_criDamCl.apply(this, arguments);
    this._criticalmode = false;
};

const _Sprite_Damage_setupCriticalEffect_criDamCl = Sprite_Damage.prototype.setupCriticalEffect;
Sprite_Damage.prototype.setupCriticalEffect = function() {
    _Sprite_Damage_setupCriticalEffect_criDamCl.apply(this, arguments);
    this._flashColor = CrtFlashColor.split(",").map(Number);
    this._flashDuration = CrtFlashTime;
};

const _Sprite_Damage_setup_criDamCl = Sprite_Damage.prototype.setup;
Sprite_Damage.prototype.setup = function(target) {
    const result = target.result();
    if (result.critical) {
        this._criticalmode = true;
    }
    _Sprite_Damage_setup_criDamCl.apply(this, arguments);
};

const _Sprite_Damage_fontSize_criDamCl = Sprite_Damage.prototype.fontSize;
Sprite_Damage.prototype.fontSize = function() {
    if (this._criticalmode) {
        return $gameSystem.mainFontSize() + DamFontUp + CrtDamFontUp
    } else {
        return $gameSystem.mainFontSize() + DamFontUp;
    }
};

const _Sprite_Damage_createBitmap_criDamCl = Sprite_Damage.prototype.createBitmap;
Sprite_Damage.prototype.createBitmap = function(width, height) {
    
    return_bitmap = _Sprite_Damage_createBitmap_criDamCl.apply(this, arguments);
    
    if (this._criticalmode) {
        const bitmap = new Bitmap(width, height);
        bitmap.fontFace = this.fontFace();
        bitmap.fontSize = this.fontSize();
        bitmap.textColor = this.damageColor_critical();
        bitmap.outlineColor = this.outlineColor_critical();
        bitmap.outlineWidth = this.outlineWidth();
        return_bitmap = bitmap;
    }
    else{
        if(DamFontChange){
            //return_bitmap.textColor = this.damageColor_normal();
            return_bitmap.outlineColor = this.outlineColor_normal();
            //return_bitmap.outlineWidth = this.outlineWidth();
        }
    }
    
    return return_bitmap;
};

Sprite_Damage.prototype.damageColor_normal = function() {
    return "rgba(" + DamColor + ")";
};

Sprite_Damage.prototype.outlineColor_normal = function() {
    return "rgba(" + DamEdge + ")";
};


Sprite_Damage.prototype.damageColor_critical = function() {
    return "rgba(" + CrtDamColor + ")";
};

Sprite_Damage.prototype.outlineColor_critical = function() {
    return "rgba(" + CrtDamEdge + ")";
};

})();